clear all
set matsize 10000
set maxvar 100000
set more off

cd "\IRI data"
	
*** Program to estimate trends in price

	import delimited "iri_wm_panel_new.csv"

	merge m:1 iri_key using entries_wide_11.dta
	drop _merge
	
** Create WM post-entry and entry week indicator

	local d = 11
	rename wmid* idwm*
	forvalues i=1/19 {
		capture gen wm`i' = (weekid >= week`i')
		capture gen enter`i' = (weekid == week`i')
		capture gen since`i' = weekid - week`i'
		capture replace since`i' = . if dis`i' > `d'
		capture replace dis`i' = 0 if wm`i' == 0
		}
		egen wm = rowtotal(wm*)
		egen enter = rowtotal(enter*)
		
		encode market, gen(mkt)
	
** Setup
	rename iri_key stores
	xtset stores weekid
	
	* Distance spline
	forvalues s=1/1 {
		forvalues i=1/24 {
			capture gen I_`i'_`s' = (dis`i' <= `s' & dis`i' > 0 )
			}
		egen wm_`s' = rowtotal(I_*_`s')
		drop I*
		}

	forvalues s=3(2)11 {
		local s0 = `s'-2
		forvalues i=1/24 {
			capture gen I_`i'_`s' = (dis`i' <= `s' & dis`i' > `s0' )
			}
		egen wm_`s' = rowtotal(I_*_`s')
		drop I*
		}
	
** Merge in store names
	rename stores iri_key
	merge m:1 iri_key using store_names.dta
	drop if _merge == 2
	drop _merge
	rename iri_key stores
	
	* Merge in chain info
	merge m:1 name using chain.dta
	drop _merge
	
	gen missing_chain = (chainid ==.)
	
	replace firmtype = 3 if firmtype == 4
	encode name, gen(chain)
	replace chain = 0 if missing_chain == 1
	
** Treatment groups
	by stores, sort: egen treat_nwm = max(wm)
	by stores, sort: egen wm0 = min(wm)
	
	gen wm_diff = treat_nwm - wm0
	
** Time since / to entry

	forvalues i=1/19 {
		capture gen enter`i'_1 = (weekid == week`i')*(dis`i' <= 1 & dis`i' > 0 )
		capture gen enter`i'_3 = (weekid == week`i')*(dis`i' <= 3 & dis`i' > 1 )
		capture gen enter`i'_5 = (weekid == week`i')*(dis`i' <= 5 & dis`i' > 3 )
		capture gen enter`i'_7 = (weekid == week`i')*(dis`i' <= 7 & dis`i' > 5 )
		capture gen enter`i'_9 = (weekid == week`i')*(dis`i' <= 9 & dis`i' > 7 )
		capture gen enter`i'_11 = (weekid == week`i')*(dis`i' <= 11 & dis`i' > 9 )
		}
	egen enter_1 = rowtotal(enter*_1)
	egen enter_3 = rowtotal(enter*_3)
	egen enter_5 = rowtotal(enter*_5)
	egen enter_7 = rowtotal(enter*_7)
	egen enter_9 = rowtotal(enter*_9)
	egen enter_11 = rowtotal(enter*_11)
	forvalues i=1/19 {
		capture drop enter`i'_*
		}
		
	local d = 8
	* Post
	local max = 104
	local max0 = `max' - `d' + 1
	forvalues t=1(`d')`max0' {
		local k = `t' + `d'
		forvalues i=1/19 {
*			capture gen timesincetreat`t'_`i' = (since`i' < `k' & since`i' >= `t')
			capture gen timesincetreat`t'_`i'_1 = (since`i' < `k' & since`i' >= `t')*(dis`i' <= 1 & dis`i' > 0 )
			capture gen timesincetreat`t'_`i'_3 = (since`i' < `k' & since`i' >= `t')*(dis`i' <= 3 & dis`i' > 1 )
			capture gen timesincetreat`t'_`i'_5 = (since`i' < `k' & since`i' >= `t')*(dis`i' <= 5 & dis`i' > 3 )
			capture gen timesincetreat`t'_`i'_7 = (since`i' < `k' & since`i' >= `t')*(dis`i' <= 7 & dis`i' > 5 )
			capture gen timesincetreat`t'_`i'_9 = (since`i' < `k' & since`i' >= `t')*(dis`i' <= 9 & dis`i' > 7 )
			capture gen timesincetreat`t'_`i'_11 = (since`i' < `k' & since`i' >= `t')*(dis`i' <= 11 & dis`i' > 9 )
			}
		egen timesincetreat`d'_`t'_1 = rowtotal(timesincetreat`t'_*_1)
		egen timesincetreat`d'_`t'_3 = rowtotal(timesincetreat`t'_*_3)
		egen timesincetreat`d'_`t'_5 = rowtotal(timesincetreat`t'_*_5)
		egen timesincetreat`d'_`t'_7 = rowtotal(timesincetreat`t'_*_7)
		egen timesincetreat`d'_`t'_9 = rowtotal(timesincetreat`t'_*_9)
		egen timesincetreat`d'_`t'_11 = rowtotal(timesincetreat`t'_*_11)
		drop timesincetreat`t'_*
		}
	forvalues i=1/19 {
		capture gen timesincetreat`max'_`i'_1 = (since`i' > `max' & since`i' < .)*(dis`i' <= 1 & dis`i' > 0 )
		capture gen timesincetreat`max'_`i'_3 = (since`i' > `max' & since`i' < .)*(dis`i' <= 3 & dis`i' > 1 )
		capture gen timesincetreat`max'_`i'_5 = (since`i' > `max' & since`i' < .)*(dis`i' <= 5 & dis`i' > 3 )
		capture gen timesincetreat`max'_`i'_7 = (since`i' > `max' & since`i' < .)*(dis`i' <= 7 & dis`i' > 5 )
		capture gen timesincetreat`max'_`i'_9 = (since`i' > `max' & since`i' < .)*(dis`i' <= 9 & dis`i' > 7 )
		capture gen timesincetreat`max'_`i'_11 = (since`i' > `max' & since`i' < .)*(dis`i' <= 11 & dis`i' > 9 )
		}	
	egen timesincetreat`d'_`max'_1 = rowtotal(timesincetreat`max'_*_1)
	egen timesincetreat`d'_`max'_3 = rowtotal(timesincetreat`max'_*_3)
	egen timesincetreat`d'_`max'_5 = rowtotal(timesincetreat`max'_*_5)
	egen timesincetreat`d'_`max'_7 = rowtotal(timesincetreat`max'_*_7)
	egen timesincetreat`d'_`max'_9 = rowtotal(timesincetreat`max'_*_9)
	egen timesincetreat`d'_`max'_11 = rowtotal(timesincetreat`max'_*_11)
	drop timesincetreat`max'_*
		
	* Pre
	forvalues i=1/19 {
		capture by stores, sort: egen max = max(dis`i')
		capture drop dis`i'
		capture rename max dis`i'
		}
	
	local max = 104
	local max0 = `max' - `d' + 1
	forvalues t=1(`d')`max0' {
		local k = `t' + `d'
		forvalues i=1/19 {
*			capture gen timetotreat`t'_`i' = (since`i' > -`k' & since`i' <= -`t')
			capture gen timetotreat`t'_`i'_1 = (since`i' > -`k' & since`i' <= -`t')*(dis`i' <= 1 & dis`i' > 0 )
			capture gen timetotreat`t'_`i'_3 = (since`i' > -`k' & since`i' <= -`t')*(dis`i' <= 3 & dis`i' > 1 )
			capture gen timetotreat`t'_`i'_5 = (since`i' > -`k' & since`i' <= -`t')*(dis`i' <= 5 & dis`i' > 3 )
			capture gen timetotreat`t'_`i'_7 = (since`i' > -`k' & since`i' <= -`t')*(dis`i' <= 7 & dis`i' > 5 )
			capture gen timetotreat`t'_`i'_9 = (since`i' > -`k' & since`i' <= -`t')*(dis`i' <= 9 & dis`i' > 7 )	
			capture gen timetotreat`t'_`i'_11 = (since`i' > -`k' & since`i' <= -`t')*(dis`i' <= 11 & dis`i' > 9 )			
			}
		egen timetotreat`d'_`t'_1 = rowtotal(timetotreat`t'_*_1)
		egen timetotreat`d'_`t'_3 = rowtotal(timetotreat`t'_*_3)
		egen timetotreat`d'_`t'_5 = rowtotal(timetotreat`t'_*_5)
		egen timetotreat`d'_`t'_7 = rowtotal(timetotreat`t'_*_7)
		egen timetotreat`d'_`t'_9 = rowtotal(timetotreat`t'_*_9)
		egen timetotreat`d'_`t'_11 = rowtotal(timetotreat`t'_*_11)
		drop timetotreat`t'_*
		}
	forvalues i=1/19 {
		capture gen timetotreat`max'_`i'_1 = (since`i' < -`max')*(dis`i' <= 1 & dis`i' > 0 )
		capture gen timetotreat`max'_`i'_3 = (since`i' < -`max')*(dis`i' <= 3 & dis`i' > 1 )
		capture gen timetotreat`max'_`i'_5 = (since`i' < -`max')*(dis`i' <= 5 & dis`i' > 3 )
		capture gen timetotreat`max'_`i'_7 = (since`i' < -`max')*(dis`i' <= 7 & dis`i' > 5 )
		capture gen timetotreat`max'_`i'_9 = (since`i' < -`max')*(dis`i' <= 9 & dis`i' > 7 )
		capture gen timetotreat`max'_`i'_11 = (since`i' < -`max')*(dis`i' <= 11 & dis`i' > 9 )
		}	
	egen timetotreat`d'_`max'_1 = rowtotal(timetotreat`max'_*_1)
	egen timetotreat`d'_`max'_3 = rowtotal(timetotreat`max'_*_3)
	egen timetotreat`d'_`max'_5 = rowtotal(timetotreat`max'_*_5)
	egen timetotreat`d'_`max'_7 = rowtotal(timetotreat`max'_*_7)
	egen timetotreat`d'_`max'_9 = rowtotal(timetotreat`max'_*_9)
	egen timetotreat`d'_`max'_11 = rowtotal(timetotreat`max'_*_11)
	drop timetotreat`max'_*
	
	drop since*
	compress
	
** Create variables

	merge m:1 monthid using cpi.dta
	drop _merge
	
	foreach var in carbbev coffee coldcer fzdinent fzpizza hotdog margbutr mayo mustketc peanbutr saltsnck soup spagsauc sugarsub yogurt {
		gen `var'_price = (`var' / `var'_vol_sales) / cpi * 100
		drop `var' `var'_vol_sales
		}
		
	* Recode outlier
	qui sum fzdinent_price, detail
	replace fzdinent_price = . if fzdinent_price > `r(p99)'

	foreach var in carbbev coffee coldcer fzdinent fzpizza hotdog margbutr mayo mustketc peanbutr saltsnck soup spagsauc sugarsub yogurt {
		gen logp_vol_`var' = log(`var'_price)
		gen logp_avg_`var' = log(`var'_avg_price / cpi * 100)
		}
		
	compress

keep stores timetotreat* timesincetreat* weekid wm wm_* mkt chain* enter enter_* logp* firmtype treat_nwm week*

	egen pre_1 = rowmax(timetotreat8_*_1)
	egen pre_3 = rowmax(timetotreat8_*_3)
	egen pre_5 = rowmax(timetotreat8_*_5)
	egen pre_7 = rowmax(timetotreat8_*_7)		
	
** Stack datasets

	preserve
	foreach var in carbbev coffee coldcer fzdinent fzpizza hotdog margbutr mayo mustketc peanbutr saltsnck soup spagsauc sugarsub yogurt {
		keep stores timetotreat* timesincetreat* weekid wm wm_* mkt chain* enter enter_* firmtype logp*_`var' treat_nwm week* pre_*
		gen category = "`var'"
		rename logp_vol_`var' logp_vol
		rename logp_avg_`var' logp_avg
		save `var'.dta, replace
		restore, preserve
		}
	restore, not
		
	clear
	foreach var in carbbev coffee coldcer fzdinent fzpizza hotdog margbutr mayo mustketc peanbutr saltsnck soup spagsauc sugarsub yogurt {
		append using `var'.dta
		erase `var'.dta
		}
		
	encode category, gen(cat)
	egen storecat = group(stores cat)
	xtset storecat weekid
		
** Regressions
	cd "\Results"
	
*	drop timetotreat*_1_*

	qui reghdfe logp_vol timetotreat8_*_1 enter_1 timesincetreat8_*_1 timetotreat8_*_3 enter_3 timesincetreat8_*_3 timetotreat8_*_5 enter_5 timesincetreat8_*_5 timetotreat8_*_7 enter_7 timesincetreat8_*_7 enter_9 enter_11 wm_9 wm_11 i.cat#c.weekid i.cat#c.weekid#c.weekid i.mkt#c.weekid i.mkt#c.weekid#c.weekid i.treat_nwm#c.weekid i.treat_nwm#c.weekid#c.weekid, a(weekid storecat, savefe) cluster(stores) keepsing	
		outreg2 using final_price_trends2, excel replace noast nose
	
	reg logp_vol timetotreat8_*_1 enter_1 timesincetreat8_*_1 timetotreat8_*_3 enter_3 timesincetreat8_*_3 timetotreat8_*_5 enter_5 timesincetreat8_*_5 timetotreat8_*_7 enter_7 timesincetreat8_*_7 enter_9 enter_11 wm_9 wm_11 i.cat#c.weekid i.cat#c.weekid#c.weekid i.mkt#c.weekid i.mkt#c.weekid#c.weekid i.treat_nwm#c.weekid i.treat_nwm#c.weekid#c.weekid __hdfe1__ __hdfe2__, cluster(stores)	
		outreg2 using final_price_trends2, excel noast nose
		predict yhat, xb
		replace yhat = yhat - __hdfe1__ - __hdfe2__	
	reg yhat timetotreat8_104_1 pre_1 enter_1 timesincetreat8_*_1 timetotreat8_104_3 pre_3 enter_3 timesincetreat8_*_3 timetotreat8_104_5 pre_5 enter_5 timesincetreat8_*_5 timetotreat8_104_7 pre_7 enter_7 timesincetreat8_*_7 enter_9 enter_11 wm_9 wm_11 i.cat#c.weekid i.cat#c.weekid#c.weekid i.mkt#c.weekid i.mkt#c.weekid#c.weekid i.treat_nwm#c.weekid i.treat_nwm#c.weekid#c.weekid, cluster(stores)	
		outreg2 using final_price_trends2, excel noast nose	
		
		
		
	
	
